<!DOCTYPE html>
<html lang="es-pe">
<head>
<meta charset="utf-8">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<meta name="viewport" content="width=device-width, initial-scale=1">
<!-- The above 3 meta tags *must* come first in the head; any other head content must come *after* these tags -->

<!-- favicon -->
<link rel="shortcut icon" href="img/favicon.png">
<!-- Bootstrap -->
<link rel="stylesheet" href="css/bootstrap.min.css">
<!-- Bootstrap Select -->
<link rel="stylesheet" href="css/bootstrap-select.min.css">
<!-- main css -->
<link rel="stylesheet" href="css/main.css">

<!-- HTML5 shim and Respond.js for IE8 support of HTML5 elements and media queries -->
<!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
<!--[if lt IE 9]>
  <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
  <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
<![endif]-->

<!-- EN CADA PÁGINA ############################# -->
<title>SEMINARIO INTERNACIONAL UDEP | Admisión UDEP</title>
<!-- Basic HTML Meta Tags -->
<meta name='title' content='SEMINARIO INTERNACIONAL UDEP | Admisión UDEP' />
<meta name='description' content='El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.' />
<meta name='url' content='http://www.feliznavidad.pe/seminariointernacionaludep/' />
<meta name='keywords' content='SEMINARIO INTERNACIONAL UDEP, Seminario Internacional de Reputación Educativa' />
<!-- OpenGraph Meta Tags -->
<meta property="og:type" content='website' />
<meta property='og:title' content='SEMINARIO INTERNACIONAL UDEP | Admisión UDEP' />
<meta property='og:description' content='El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.' />
<meta property='og:url' content='http://www.feliznavidad.pe/seminariointernacionaludep/' />
<meta property='og:image' content='http://www.admisionudep.com/form_2017/landing/certificacion-reputacion/img/foto-certificacion-3.jpg' />
<!-- ############################################ -->
</head>
<body>

<script>
    /*(function(i,s,o,g,r,a,m){i['GoogleAnalyticsObject']=r;i[r]=i[r]||function(){
   (i[r].q=i[r].q||[]).push(arguments)},i[r].l=1*new Date();a=s.createElement(o),
   m=s.getElementsByTagName(o)[0];a.async=1;a.src=g;m.parentNode.insertBefore(a,m)
   })(window,document,'script','//www.google-analytics.com/analytics.js','ga');
   ga('create', 'UA-55699707-1', 'auto');
   ga('send', 'pageview');*/
</script>

<header>
	<!-- <img class="img-responsive" src="http://placehold.it/1280x410" alt="..."> -->
      <div id="fondo" class="">
      	<!--<img class="img-responsive hidden-xs" src="img/landing-cabecera.jpg" alt="...">
      	<img class="img-responsive visible-xs" src="img/landing-cabecera-cel.jpg" alt="...">-->
            
            <div class="container relative">
                  <div class="row center-block">      
                        <img class="img-responsive titulo" src="img/titulo.svg" alt="...">      
                  </div>      
                        <!--</div>
                  </div>
            <!--</div> -->
      </div>
           
</header>



<div id="seccion-uno">
      <div class="faja">
            <div class="container relative">
                  <div class="row">
                        <div class="col-xs-4 col-sm-4">
                              <img class="img-responsive"  src="img/logo-01.svg" alt="...">
                        </div>
                        <div class="col-xs-4 col-sm-4">
                              <img class="img-responsive center-block"  src="img/logo-02.svg" alt="...">
                        </div>
                        <div class="col-xs-4 col-sm-4">
                               <img class="img-responsive center-block pull-right"   src="img/logo-03.png" alt="...">
                        </div>
                  </div>
            </div>
      </div>
	<div class="container">
		<div class="row">
			<div class="col-sm-12 context">
				<p class="titulo1">MIÉRCOLES 30 DE MAYO</p>
                        <p class="titulo2">8:00 A.M. a 5:00 P.M.</p>
                        <p class="titulo3">Salón San Martín del Hotel J.W. Marriott Lima</p>

                        <hr class="hr-custom">

                        <p class="text-justify">El espíritu de la Universidad de Piura se centra en brindar formación integral y preparación profesional a sus alumnos, de modo que puedan promover el bien común en la sociedad.</p>

                        <p class="text-justify">Este mismo principio lo compartimos con los colegios, que son el primer paso para brindar una educación basada en valores. Bajo esta visión, de formar profesionales completos y con el ánimo de impulsar y divulgar temas relevantes que contribuyan a este objetivo es que creamos el <strong class="bold"> Seminario Internacional de Reputación Educativa</strong> en su segunda edición que nos ayudará a absolver algunas dudas comono resueltas el 2017.</p>
			</div>
			
		</div>
	</div>
</div>

<div id="seccion-dos">
	<div class="container">
		<div class="row row-table">
			<div class="col-sm-4">
				<div class="txt-confirma">
					Confirma tu
					<br>asistencia:
				</div>
				<p>Ingrese los datos del Director y un invitado para confirmar tu asistencia:</p>
				<p><strong><small>* En caso requerir una vacante adicional por favor contactar con su Gestora de Canal.</small></strong></p>
			</div>
			<div class="col-sm-8">
				<form method="post" id="formulario" action="">
					<div class="row">
						<div class="col-sm-6 col-padding">
							<div class="txt-label">Datos Personales:</div>
							<div class="form-group">
								<input type="text" class="form-control" placeholder="Nombres y Apellidos" name="asistente">
							</div>

							<div class="form-group">
								<input type="text" class="form-control" placeholder="Correo" name="correo">
							</div>

							<!--<div class="txt-label"></div>-->
							<div class="form-group">
                                <select class="form-control selectpicker" name="cargo" title="Selecciona tu Cargo">
                                    <option value="Director(a)">Director(a)</option>
                                    <option value="Orientador(a) Vocacional">Orientador(a) Vocacional</option>
                                    <option value="Psicologo(a)">Psicologo(a)</option>
                                    <option value="Docente">Docente</option>
								</select>
							</div>
						</div>
						<div class="col-sm-6 col-padding">
							<div class="txt-label">Colegio:</div>
							<div class="form-group">
								<!--<input type="text" class="form-control" placeholder="Nombre asistente" name="invitado01_nombre">-->
                                <select class="form-control selectpicker" name="colegio" title="Selecciona...">
                                    <option value="Abraham Lincoln">Abraham Lincoln</option>
                                    <option value="Alexander Von Humboldt">Alexander Von Humboldt</option>
                                    <option value="Alpamayo">Alpamayo</option>
                                    <option value="Altair">Altair</option>
                                    <option value="América del Callao">América del Callao</option>
                                    <option value="Anglo Americano Prescott (Arequipa)">Anglo Americano Prescott (Arequipa)</option>
                                    <option value="Antares">Antares</option>
                                    <option value="Antonio Raimondi">Antonio Raimondi</option>
                                    <option value="Augusto Weberbauer">Augusto Weberbauer</option>
                                    <option value="Beata Imelda">Beata Imelda</option>
                                    <option value="Cambridge College">Cambridge College</option>
                                    <option value="Casuarinas College">Casuarinas College</option>
                                    <option value="Champagnat">Champagnat</option>
                                    <option value="Claretiano">Claretiano</option>
                                    <option value="Cooperativo la Unión">Cooperativo la Unión</option>
                                    <option value="Cooperativo San Felipe">Cooperativo San Felipe</option>
                                    <option value="Corazón de María (Tacna)">Corazón de María (Tacna)</option>
                                    <option value="Cristo Rey">Cristo Rey</option>
                                    <option value="Cristo salvador">Cristo salvador</option>
                                    <option value="Dalton">Dalton</option>
                                    <option value="De Jesús">De Jesús</option>
                                    <option value="De la Inmaculada">De la Inmaculada</option>
                                    <option value="El Buen Pastor">El Buen Pastor</option>
                                    <option value="Euroamericano">Euroamericano</option>
                                    <option value="Evariste Galois">Evariste Galois</option>
                                    <option value="Fap José Abelardo Quiñones">Fap José Abelardo Quiñones</option>
                                    <option value="Fap Manuel Polo Jimenez">Fap Manuel Polo Jimenez</option>
                                    <option value="Franco Peruano">Franco Peruano</option>
                                    <option value="Franklin D. Roosevelt">Franklin D. Roosevelt</option>
                                    <option value="Hiram Bingham">Hiram Bingham</option>
                                    <option value="Hosanna">Hosanna</option>
                                    <option value="Humtec">Humtec</option>
                                    <option value="Isabel Flores de Oliva">Isabel Flores de Oliva</option>
                                    <option value="Jesús Salvador">Jesús Salvador</option>
                                    <option value="José Antonio Encinas">José Antonio Encinas</option>
                                    <option value="José Carlos Mariátegui (Junín)">José Carlos Mariátegui (Junín)</option>
                                    <option value="La Inmaculada Concepción">La Inmaculada Concepción</option>
                                    <option value="La Reparación">La Reparación</option>
                                    <option value="San Jose la Salle (Cuzco)">San Jose la Salle (Cuzco)</option>
                                    <option value="De La Salle (Arequipa)">De La Salle (Arequipa)</option>
                                    <option value="León Pinelo">León Pinelo</option>
                                    <option value="Leonardo da Vinci">Leonardo da Vinci</option>
                                    <option value="Libertador san Martín">Libertador san Martín</option>
                                    <option value="Liceo Naval Almirante Guise">Liceo Naval Almirante Guise</option>
                                    <option value="Lomas de Santa María">Lomas de Santa María</option>
                                    <option value="Los Alamos">Los Alamos</option>
                                    <option value="Magister">Magister</option>
                                    <option value="María Alvarado">María Alvarado</option>
                                    <option value="María Auxiliadora">María Auxiliadora</option>
                                    <option value="María de las Mercedes">María de las Mercedes</option>
                                    <option value="María de los Ángeles">María de los Ángeles</option>
                                    <option value="María Molinari">María Molinari</option>
                                    <option value="María Reina Marianistas">María Reina Marianistas</option>
                                    <option value="Markham College">Markham College</option>
                                    <option value="Mater Admirabilis">Mater Admirabilis</option>
                                    <option value="Mater Purissima">Mater Purissima</option>
                                    <option value="Max Uhle (Arequipa)">Max Uhle (Arequipa)</option>
                                    <option value="Medalla de María">Medalla de María</option>
                                    <option value="Miravalles">Miravalles</option>
                                    <option value="Montealto">Montealto</option>
                                    <option value="Newton College">Newton College</option>
                                    <option value="Nivel A">Nivel A</option>
                                    <option value="Nuestra Señora de la Luz">Nuestra Señora de la Luz</option>
                                    <option value="Nuestra Señora de la Reconciliación">Nuestra Señora de la Reconciliación</option>
                                    <option value="Nuestra Señora de Montserrat">Nuestra Señora de Montserrat</option>
                                    <option value="Nuestra Señora del Carmen">Nuestra Señora del Carmen</option>
                                    <option value="Nuestra Señora del Carmen (Barranco)">Nuestra Señora del Carmen (Barranco)</option>
                                    <option value="Nuestra Señora del Consuelo">Nuestra Señora del Consuelo</option>
                                    <option value="Nuestra Señora del Pilar (Arequipa)">Nuestra Señora del Pilar (Arequipa)</option>
                                    <option value="Pedro Ruiz Gallo">Pedro Ruiz Gallo</option>
                                    <option value="Peruano Británico">Peruano Británico</option>
                                    <option value="Peruano Chino 10 de Octubre">Peruano Chino 10 de Octubre</option>
                                    <option value="Peruano Chino Juan XXIII">Peruano Chino Juan XXIII</option>
                                    <option value="Peruano Japonés la Victoria">Peruano Japonés la Victoria</option>
                                    <option value="Pestalozzi">Pestalozzi</option>
                                    <option value="Pio XII">Pio XII</option>
                                    <option value="Regina Pacis">Regina Pacis</option>
                                    <option value="Reina de los Ángeles">Reina de los Ángeles</option>
                                    <option value="Reina del Mundo">Reina del Mundo</option>
                                    <option value="S.c. Sophianum">S.c. Sophianum</option>
                                    <option value="Saco Oliveros - Pueblo Libre">Saco Oliveros - Pueblo Libre</option>
                                    <option value="Saco Oliveros - Santa Beatriz">Saco Oliveros - Santa Beatriz</option>
                                    <option value="Salcantay">Salcantay</option>
                                    <option value="Salesiano (Cuzco)">Salesiano (Cuzco)</option>
                                    <option value="Salesiano San Francisco de Sales">Salesiano San Francisco de Sales</option>
                                    <option value="San Agustín">San Agustín</option>
                                    <option value="San Antonio de Padua">San Antonio de Padua</option>
                                    <option value="San Charbel">San Charbel</option>
                                    <option value="San Francisco de Borja">San Francisco de Borja</option>
                                    <option value="San Ignacio de Recalde">San Ignacio de Recalde</option>
                                    <option value="San José (Arequipa)">San José (Arequipa)</option>
                                    <option value="San José de Cluny - Barranco">San José de Cluny - Barranco</option>
                                    <option value="San José de Cluny - Surquillo">San José de Cluny - Surquillo</option>
                                    <option value="San José de Monterrico">San José de Monterrico</option>
                                    <option value="San José la Salle">San José la Salle</option>
                                    <option value="San Juan María Vianney">San Juan María Vianney</option>
                                    <option value="San Norberto">San Norberto</option>
                                    <option value="San Pablo">San Pablo</option>
                                    <option value="San Pedro">San Pedro</option>
                                    <option value="San Silvestre School">San Silvestre School</option>
                                    <option value="Santa Ana">Santa Ana</option>
                                    <option value="Santa Ana (Cuzco)">Santa Ana (Cuzco)</option>
                                    <option value="Santa Margarita">Santa Margarita</option>
                                    <option value="Santa María">Santa María</option>
                                    <option value="Santa María Marianistas">Santa María Marianistas</option>
                                    <option value="Santa Matilde">Santa Matilde</option>
                                    <option value="Santa Rita de Casia">Santa Rita de Casia</option>
                                    <option value="Santa Rosa (Cuzco)">Santa Rosa (Cuzco)</option>
                                    <option value="Santa Teresita">Santa Teresita</option>
                                    <option value="Santa Úrsula">Santa Úrsula</option>
                                    <option value="Santísimo Nombre de Jesús">Santísimo Nombre de Jesús</option>
                                    <option value="Sor Querubina de San Pedro">Sor Querubina de San Pedro</option>
                                    <option value="Sor Rosa Larrabure">Sor Rosa Larrabure</option>
                                    <option value="SS.CC. Belen">SS.CC. Belen</option>
                                    <option value="SS.CC. Recoleta">SS.CC. Recoleta</option>
                                    <option value="ST. George´s College">ST. George´s College</option>
                                    <option value="Trener">Trener</option>
                                    <option value="Trilce - Chorrillos">Trilce - Chorrillos</option>
                                    <option value="Trilce - Roma">Trilce - Roma</option>
                                    <option value="Trilce - San Isidro">Trilce - San Isidro</option>
                                    <option value="Villa Alarife">Villa Alarife</option>
                                    <option value="Villa Caritas">Villa Caritas</option>
                                    <option value="Villa María la Planicie">Villa María la Planicie</option>
                                    <option value="Walt Whitman">Walt Whitman</option>
								</select>
							</div>
							<!--<div class="form-group">
								<input type="text" class="form-control" placeholder="Correo" name="invitado01_correo">
							</div>-->
							
							<br>
							<!--<a class="btn-enviar pull-right" href="#">ENVIAR</a>-->
                            <input type="button" id="btn_enviar" name="login" class="btn-enviar pull-right" value="ENVIAR" style="cursor:pointer; ">
                            <div id="respuesta"  style="float:left; clear:both; font-size:11px; font-weight:normal; text-align:center; color:#FC070B; border:none"></div>
						</div>
					</div>		
				</form>
			</div>
		</div>
	</div>
</div>



<div id="seccion-tres">
	<div id="accordion">
		<div id="panel-1" class="panel">
			<a class="titulo-accordion container expand" data-toggle="collapse" data-parent="#accordion" href="#collapse_1">
				Programa: miércoles 30 de mayo de 2018 (Lima)	<span class="pull-right" style="color:#fff">▼</span>
			</a>
			<div id="collapse_1" class="collapse container">
				<div class="panel-cuerpo">
					<table class="table">
						<thead>
							<tr>
								<th>HORA:</th>
								<th>SESIÓN</th>
                                                <th>EXPOSITORES</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>8:00 - 8:30</td>
								<td>Recepción, entrega de documentos.</td>
								<td></td>
							</tr>
							<tr>
								<td>9:00 - 9:15</td>
								<td>Presentación</td>
                                                <td></td>
							</tr>
                                        <tr>
                                            <td>9:15 - 9:50</td>
                                            <td>Sesión plenaria I: Un entorno que cambia.</td>
                                            <td>Fernando Huamán</td>
                                        </tr>
                                        <tr>
                                            <td>9:50 - 10:45</td>
                                            <td>Sesión plenaria II: Gestión institucional del cambio.</td>
                                             <td>Begoña Echevarne</td>
                                        </tr>
							<tr>
								<td>10:45 - 11:20</td>
								<td>Café</td>
                                                <td></td>
							</tr>
							<tr>
								<td>11:20 - 12:00</td>
								<td>Presentación de Empantallados</td>
                                                <td></td>
							</tr>
                                          <tr>
                                                <td>12:00 - 13:30</td>
                                                <td> Taller I: Estrategias de generación de contenido para la web y las redes sociales.</td>
                                                <td>Francisco Arbaiza</td>
                                          </tr>

                                          <tr class="tr_td_no_border_top">
                                                <td></td>
                                                <td>Taller II: El relato institucional.</td>
                                                <td>Begoña Echevarne</td>
                                          </tr>
							<tr>
								<td>13:30 - 15:00</td>
								<td>Almuerzo</td>
								<td></td>
							</tr>
							<tr>
								<td>15:00 - 15:50</td>
								<td>Sesión plenaria III: Gestión de crisis.</td>
                                                <td>Yago de la Cierva</td>
							</tr>
                                          <tr>
                                                <td>15:50 - 17:00</td>
                                                <td>Taller I: Crisis: resolución de casos concretos</td>
                                                <td>Yago de la Cierva</td>
                                          </tr>

                                          <tr class="tr_td_no_border_top">
                                                <td></td>
                                                <td>Taller II: Derecho y Comunicación.</td>
                                                <td>Margarita Quiroz</td>
                                          </tr>						
						</tbody>
					</table>
				</div>
			</div>
		</div>

		<!--<div id="panel-2" class="panel">
			<a class="titulo-accordion container expand" data-toggle="collapse" data-parent="#accordion" href="#collapse_2">
				Programa: jueves 27 de abril de 2017 <span class="pull-right">▼</span>
			</a>
			<div id="collapse_2" class="collapse container">
				<div class="panel-cuerpo">
					<table class="table">
						<thead>
							<tr>
								<th>HORA:</th>
								<th>SESIÓN</th>
								<th>EXPOSITOR</th>
							</tr>
						</thead>
						<tbody>
							<tr>
								<td>8:30 - 9:45</td>
								<td>Sesión 7: La curva del disenso: gestión de conflictos y controversias.</td>
                                <td>Ph.D. Yago de la Cierva</td>
							</tr>
							<tr>
								<td>9:45 - 10:30</td>
								<td>Sesión 8: Marco jurídico de las instituciones educativas.</td>
								<td>Abg. Margarita Quiroz</td>
							</tr>
							<tr>
								<td>10:30 - 11:00</td>
								<td>Coffee Break</td>
								<td></td>
							</tr>
							<tr>
								<td>11:00 - 11:45</td>
								<td>Sesión 9: Gestión de crisis.</td>
								<td>Ph.D. Yago de la Cierva</td>
							</tr>
							<tr>
								<td>11:45 - 12:45</td>
                                <td>Sesión 10: Gobierno y Comunicación en un colegio.</td>
								<td>Ph.D. Juan Manuel Mora</td>
							</tr>
							<tr>
								<td>12:45 - 1:15</td>
								<td>Conclusiones, coloquio final y cierre.</td>
								<td></td>
							</tr>
						</tbody>
					</table>
				</div>
			</div>
		</div>-->

		<div id="panel-3" class="panel">
			<a class="titulo-accordion container expand" data-toggle="collapse" data-parent="#accordion" href="#collapse_3">
				Expositores del Seminario<span class="pull-right" style="color:#fff">▼</span>
			</a>
			<div id="collapse_3" class="collapse container">
				<div class="panel-cuerpo">
					<div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-4">
                            <div class="container-autoridades">
                                <div class="autoridades">                                   
                                    <!-- <img class="img-responsive" src="http://placehold.it/360x400" alt="..."> -->
                                    <img class="center-block img-responsive" src="img/francisco-arbaiza.jpg">
                                    <div class="over">
                                        <div class="over-padre">
                                            <div class="over-celda">
                                                Profesor universitario e investigador en el ámbito de las nuevas tendencias del marketing contemporáneo. PhD en Comunicaciones de Marketing en la Universidad de Navarra (España) y Licenciado en Comunicación por la Universidad de Piura. Actualmente jefe del Área Académica de Comunicaciones de Marketing de la Facultad de Comunicación. 

                                                Autor de dos recientes libros que recogen gran parte de su investigación en los últimos años: "Marketing experiencial: el marketing a través de las experiencias del consumidor" (2017) y "Aproximación a un marketing postmoderno: la influencia del postmodernismo en las comunicaciones de marketing, el consumidor y la construcción de marcas (2016).

                                                Sus actuales proyectos de investigación incluyen: El marketing de contenidos, el storytelling publicitario y su trascendencia en el contexto comercial y social; y las marcas y su diálogo con el consumidor en los nuevos escenarios digitales.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div class="nombre">Ph.D. Francisco Arbaiza</div>
                                <div class="cargo"></div>
                            </div>
                        </div>
                    	
                        <div class="col-xs-12 col-sm-6 col-md-4">
							<div class="container-autoridades">
		                        <div class="autoridades">
		                            <img class="center-block img-responsive" src="img/yago-de-la-cierva.jpg">
		                            <div class="over">
		                            	<div class="over-padre">
		                            		<div class="over-celda">
		                            			Licenciado en Derecho, Universidad de Santiago de Compostela. Doctor en Filosofía por la Universidad de Navarra. 
												Se especializó en Comunicación Institucional en la Pont. Univ. de la Santa Cruz, Roma, y ha cursado el Program for Management Development (PMD), IESE.

												Es colaborador científico del IESE Business School, Universidad de Navarra, encargado de la asignatura “Corporate Communications”, MBA del IESE (2013 – )
												<!--Especialista en reputación corporativa y comunicaciones integrales. Profesor de “Comunicación preventiva y gestión de crisis”, Facultad de Comunicación Institucional de la Iglesia, Pontificia Universidad de la Santa Cruz, Roma (1999 – )-->
												Profesor de las materias “Organización de eventos” y “Plan de comunicación” del Máster de Protocolo, organización de eventos y comunicación”, Universidad Rey Juan Carlos (2012).
		                            		</div>
		                            	</div>
		                            </div>
		                        </div>
		                        <br>
		                        <div class="nombre">Ph.D. Yago de la Cierva</div>
		                        <div class="cargo"></div>
		                    </div>
						</div>
                    </div>

                    <div class="row">
                        <div class="col-xs-12 col-sm-6 col-md-4">
                            <div class="container-autoridades">
                                <div class="autoridades">
                                    <img class="center-block img-responsive" src="img/fernando-huaman.jpg">
                                    <div class="over">
                                        <div class="over-padre">
                                            <div class="over-celda">
                                                Doctor Internacional en Comunicación por la Universidad de Navarra (España). Licenciado en Comunicación, Bachiller en Filosofía y Diplomado en Educación por la Universidad de Piura (Perú). Premio Extraordinario de Doctorado en Comunicación. Investigador en Comunicación y director del Centro de Investigación en Opinión Pública (CIOP) de la Facultad de Comunicación de la Universidad de Piura. Director de Departamento.
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <br>
                                <div class="nombre">Dr. Fernando Huamán</div>
                                <div class="cargo"></div>
                            </div>
                        </div>
                        
						<div class="col-xs-12 col-sm-6 col-md-4">
							<div class="container-autoridades">
		                        <div class="autoridades">
		                            <img class="center-block img-responsive" src="img/margarita-quiroz.jpg">
		                            <div class="over">
		                            	<div class="over-padre">
		                            		<div class="over-celda">											
												Es asesora de comunicación en distintas instituciones educativas y sociales en diversos estados, y comentarista semanal en el programa Matutino Express de ForoTV, Televisa.

												Tiene un MBA por el IPADE Business School (2013-2015), y un posgrado – Bachillerato en Teología en la Universidad de la Santa Croce, Roma (2006 al 2009).

												Ha sido ponente en algunos foros internacionales de comunicación, en Costa Rica, Roma, y Cochabamba – Bolivia. Ha participado en distintos foros de debate en la opinión pública, y trabajado como corresponsal en eventos internacionales, como Beijing +5 en Nueva York y la Jornada Mundial de la Juventud en Colonia, Alemania.
		                            		</div>
		                            	</div>
		                            </div>
		                        </div>
		                        <br>
		                        <div class="nombre">Abogada. Margarita María Quiroz</div>
		                        <div class="cargo"></div>
		                    </div>
						</div>
					</div>
                    
				</div>
			</div>
		</div>
	</div>
</div>



<footer>
	<div class="container">
		Universidad de Piura - Todos los derechos reservados 2017
	</div>
</footer>

<?php include "include/disclaimer.php"; ?>

<!-- jQuery (necessary for Bootstrap's JavaScript plugins) -->
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js"></script>
<!--<script src="//ajax.googleapis.com/ajax/libs/jquery/1.11.2/jquery.min.js"></script>-->
<!-- Include all compiled plugins (below), or include individual files as needed -->
<script src="js/bootstrap.min.js"></script>
<!-- Bootstrap Select -->
<script src="js/bootstrap-select.min.js"></script>

<!--Plug-in Initialisation-->
	<script type="text/javascript">
		// $(document).ready(function() {
		// });

		$(function() {
		  $(".expand").on( "click", function() {
		    // $(this).next().slideToggle(200);
		    $expand = $(this).find(">:first-child");
		    
		    if($expand.text() == "▼") {
		      $expand.text("▲");
		    } else {
		      $expand.text("▼");
		    }
		  });
		  
		$("#btn_enviar").click(function(){
			var url = "send.php"; // El script a dónde se realizará la petición.
			$("#respuesta").html("Procesando, espere por favor...");
			$("#btn_enviar").css("display", "none");
			$.ajax({
				type: "POST",
				url: url,
				data: $("#formulario").serialize(), // Adjuntar los campos del formulario enviado.
				success: function(data){
					ncantidad = data.length;
					//alert(ncantidad);
					if ( ncantidad <= "10"){
							$("#respuesta").html("<span style='color:#3C0'>Tus datos han sido guardados correctamente!</span>");
							$(".form-control").val("");
							$("#btn_enviar").css("display", "inline-block");
					}else{
						//$("#respuesta").html("<span style='color:#000'>"+data+"</span>"); // Mostrar la respuestas del script PHP.
						$("#respuesta").html(data);
						$("#btn_enviar").css("display", "inline-block");
					}
				}
			});
			return false; // Evitar ejecutar el submit del formulario.
		});
		  
		});
    </script>
   
    
</body>
</html>